       subroutine theory (timnow,nplcs ,volklk,
     +                    zmassa,zmasth,
     +                    salwz ,salklk,salijm,
     +                    rhowz ,rhoklk,rhoijm,
     +                    salt  ,rho          )
c************************************************************************
c
c         D e l t a r e s  -   Unit: Deltares Software Centre
c
c             Module: Subroutine THEORY
c           Function: Berekenen zoutmassa ZMASTH in kolk t.o.v. initiele 
c                     zoutmassa ZMAS0 met theoretische formulering
c                     (LOCKEX) en truncaties op min/max zoutmassa in 
c                     kolk conform PLCLOG. 
c
c                     Via NOLOSS variatie in oplossingen:
c
c                     NOLOSS =.true.  Zoutmassa volgens energie-behoudende 
c                                     formulering, zie LOCKEX.
c                     NOLOSS =.false. Zoutmassa volgens maximaal energie-
c                                     verlies formulering, zie LOCKEX.
c
c        Method used: Aanroep door programma STEVIN ; uitvoer van deze 
c                     resultaten in subroutine TSERIE.
c
c               Date: 16-05-2010
c         Programmer: R.E. Uittenbogaard
c************************************************************************
      include      'pardef.inc'
      include      'units.inc'
      include      'physco.inc'
      include      'timefr.inc'
      include      'hydarr.inc'
c
      dimension     salt(7,6),rho(7,6)
      dimension     nplcs (20,38) 
c

      save          ifirst,
     +              nwz0  ,nijm0 ,
     +              n2wz  ,n2ijm , 
     +              zmas0 ,   
     +              topen ,tclose ,
     +              salin ,rhoin  ,
     +              salout,rhoout 
c
      data          noval/0/,ifirst/0/
c
      if (ifirst.eq.0) then
         topen  = timnow
         tclose = timnow
         zmas0  = zmassa       
         nwz0   = 1
         nijm0  = 1
         n2wz   = 0
         n2ijm  = 0
         ifirst = 1      
      endif
c----------------------------------------------------------------------
c Deur open signaal, combineer eb- en vloeddeuren per zoet/zout zijde,
c controleer met 1 van de 2 deuren per set vloed- en ebdeuren.
c Het is mogelijk dat zowel eb- als vloeddeuren gesloten zijn, trunceer
c daarom NWZ of NIJM tot hooguit NWZ/NIJM=1 i.v.m. besliscriteria voor 
c openen/sluiten kolk.
c----------------------------------------------------------------------
      nwz   = min(1,nplcs(4,1)+nplcs(4, 5))
      nijm  = min(1,nplcs(4,9)+nplcs(4,13))
c
c Kolk gaat open naar Waddenzee, stel vast tijdstip, saliniteit en
c dichtheid binnen (SALOPN,RHOOPN) en buiten (SALOUT,RHOOUT) de kolk:
c
      if (nwz.lt.nwz0) then
         n2wz   = 1 
         n2ijm  = 0
         topen  = timnow
         salin  = salklk
         rhoin  = rhoklk
c         
         if (wzavg) then
            salout = salwz
            rhoout = rhowz
         else
            salout = salt(1,1)
            rhoout = rho (1,1)
         endif   
c
         zmas0  = zmassa
      endif   
c 
c Kolk sluit af van Waddenzee:     
c
      if (nwz.gt.nwz0) then
         n2wz   = 0
         tclose = timnow
      endif
c
c Kolk gaat open naar IJsselmeer:
c
      if (nijm.lt.nijm0) then
         n2ijm  = 1
         n2wz   = 0
         topen  = timnow
         salin  = salklk
         rhoin  = rhoklk
c

         if (ijmavg) then
            salout = salijm
            rhoout = rhoijm
         else 
            salout = salt(7,1)
            rhoout = rho (7,1)
         endif
c         
         zmas0  = zmassa
      endif 
c
c Kolk sluit af van IJsselmeer:
c     
      if (nijm.gt.nijm0) then
         n2ijm  = 0
         tclose = timnow
      endif
c
c Indien gesloten kolk geen waarde (XNOVAL) toekennen/plotten:
c
      if ((n2wz.eq.0).and.(n2ijm.eq.0)) then
         zmasth = noval
         goto 9999
      endif
c----------------------------------------------------------------------
c Simulatie zouttransport door lock-exchange uitwisseling; DIFTIM is 
c tijd verstreken sinds openen kolk:
c----------------------------------------------------------------------
      diftim = timnow-topen
c
c Theoretische fluxen volgens LOCKEX-formules. Zonder reductie (ETTA) 
c van bellenscherm, zonder invloed drempelhoogte, empirisch bepaald 
c a.d.h.v. metingen 9 april:
c
      etta   = 1.0      
      hlex   = hkolk-hdremp         
c
c Theoretisch zouttransport gebaseerd op situatie in kolk op moment van
c openen van de sluisdeuren (SALIN en RHOIN, IN slaat op IN de kolk).
c
      call lockex(salin ,salout,rhoin ,rhoout,etta  ,
     +            cwav  ,hlex  ,hlex  ,volflx,salflx)
c
c Verschil in maximale en minimale saliniteit:
c
      sal2wz = 2.0
      sal2ij = 2.0
c
c Minimale en maximale zoutmassa te bereiken bij open kolk:
c
      zmasmx = volklk*(salwz -sal2wz) 
      zmasmn = volklk*(salijm+sal2ij)
c
c Uitgewisseld volume gedurende open-tijd DIFTIM:
c
      vollex = volflx*bvloer*diftim
c
c Uitgewisseld zoutmassa gedurende open-tijd DIFTIM:
c
      if (n2wz .eq.1) then
c++      zmasth = zmas0+(salout-salin)*vollex
         zmasth = zmas0+(salwz -salin)*vollex         
      endif
      if (n2ijm.eq.1) then
c++      zmasth = zmas0+(salout-salin)*vollex
         zmasth = zmas0+(salijm-salin)*vollex         
      endif
c

c Truncatie min-max zoutmassa in kolk bij actueel kolkvolume VOLKLK:
c
      zmasth = max(zmasmn,min(zmasth,zmasmx))
c      
9999  continue
c
c Onthoud laatste schutindicatoren:
c
      nwz0  = nwz
      nijm0 = nijm
c
c Maak aparte subroutine SHIPS 
c
c Bijdrage door uitvarend schip naar Waddenzee: 
c
c++      vschip = 1600
c++      zmas2  = zmas2+vschip*salwz
c
c Bijdrage door invarend schip uit Waddenzee: 
c
c++      vschip = 1600
c++      zmas2  = zmas2-vschip*salklk
c
c Bijdrage door invarend schip uit IJsselmeer:
c
c++      vschip = 1600.    
c++      zmas2  = zmas2-vschip*salklk
c
c Bijdrage door uitvarend schip naar IJsselmeer:
c
c++      vschip = 1600.    
c++      zmas2  = zmas2+vschip*salijm
c

      return
      end