	subroutine manctd (salt  ,rho   ,salwz ,rhowz )
c************************************************************************
c
c         D e l t a r e s  -   Unit: Deltares Software Centre
c
c             Module: subroutine MANCTD
c           Function: Inlezen handmatige metingen ipv CTD-WZ 
c
c-----------------------------------------------------------------------
c  LUNMAN : bestand met handmatige metingen
c          
c  Veronderstellingen bij opstellen/inlezen van de handmetige metingen:
c           de diepte onder het locale wateroppervlak wordt gemeten met 
c           stappen van:
c           0.2m (stalen huis van probe net volledig ondergedompeld) 
c           0.5m 
c           1.0m
c           1.5m 
c           2.0m
c           2.5m
c           etc. tot maximale diepte.
c
c           De teller voor deze dieptemetingen loopt van echter van de 
c           diepste meting (nr 1 dus) tot de meest ondiepe. Het gevolg 
c           is dat bij wisselende waterstanden, getij, het aantal 
c           vertikale posities verandert. Bij interpolatie in de tijd 
c           moet er dus vanaf het wateroppervlak geteld worden, zie 
c           daartoe de statements:
c 
c           iz1 = iz+nman1-nman
c           iz0 = iz+nman0-nman
c 
c-----------------------------------------------------------------------
c
c        Method used: aanroep door programma STEVIN, definitie invoer-file
c                     LUNMAN in subroutine DEFINE.
c
c               Date: 3-05-2010
c         Programmer: R.E. Uittenbogaard
c************************************************************************
      include      'pardef.inc'
      include      'units.inc'
      include      'physco.inc'
      include      'timefr.inc'
      include      'hydarr.inc'
c
      dimension     salt(7,6),rho(7,6)
c
c Voor handmatige metingen:
c
      dimension     conma0(20),temma0(20),depma0(20),
     +              conma1(20),temma1(20),depma1(20),      
     +              conman(20),temman(20),depman(20),
     +              salman(20),rhoman(20)
c
      character*1   star      
      character*50  fmt1,text
      character     date*8,hhman*6 
c
      logical       endman
c
      save          ifirst,endman,
     +              manse0,nman0,conma0,temma0,depma0,
     +              manse1,nman1,conma1,temma1,depma1
c      
      data          fmt1/'(a8,1x,a6,i2))'/
     +              star/'*'/,ifirst/0/,
     +              endman/.false./,mansec/0/
c
c Calibratie met Yokogawa geleidbaarheid:
c
c++   data          yokoga/0.95/
      data          yokoga/0.80/      
c----------------------------------------------------------------------- 
c Laatste gegevens ingelezen ? Spring dan direct naar de tijdsinterpolatie
c gedeelte ("8888") waar rekening wordt gehouden dan voorbij de laatste
c handmeting profielen worden opgevraagd:
c-----------------------------------------------------------------------     
      if(endman) goto 8888
c----------------------------------------------------------------------- 
c Lees headertekst zolang door "*" voorafgegaan:
c-----------------------------------------------------------------------     
      if (ifirst.eq.0) then
         ifirst = 1
11       read (lunman,'(a)') text
         if (star.eq.text(1:1)) goto 11 
c----------------------------------------------------------------------- 
c Lees datum - tijd en aantal verticale posities,
c Lees daarna de handmatige CTD-profielen: 
c----------------------------------------------------------------------- 
c
22       read (lunman,fmt1,iostat=iocond) date,hhman,nmanx
c
         if (iocond.ne.0) then
            endman = .true.
            close(lunman)
            goto 8888
         else
            read(hhman(1:2),'(i2)') nhour
            read(hhman(3:4),'(i2)') nmin
            read(hhman(5:6),'(i2)') nsec         
c
c Pas nu NMAN1 waarde geven immers bij "22" kan een end-of-file
c fout ontstaan:
c
            nman1  = nmanx 
            manse1 = nsec+60*(nmin+60*nhour)
            itdif  = manse1-nsecs(nrlmx)
c
c Lees (volgende) handmeting:
c
            do in  = 1,nman1
               read(lunman,*) iz,depma1(iz),conma1(iz),temma1(iz)
            enddo   
c
c Onthoud vorige handmeting als "0" maar zeker de allereerste voor 
c initialisatie:
c
            if (itdif.lt.0 .or. nsecs(nrlmx).lt.30) then
               manse0 = manse1
               nman0  = nman1
               do iz         = 1,nman0
                  depma0(iz) = depma1(iz)
                  conma0(iz) = conma1(iz)
                  temma0(iz) = temma1(iz)
               enddo  
            endif
c            
         endif   
c Lees eventueel verder:
         if (itdif.lt.0) goto 22
      endif   
c----------------------------------------------------------------------- 
c Wanneer ITDIF<0 dan nieuw blok aan handmetingen inlezen: 
c-----------------------------------------------------------------------
      itdif = manse1-nsecs(nrlmx) 
c      
      if (itdif.lt.0) then 
33       continue
c
c Onthoud vorige handmeting "0" voor interpolatie in de tijd: 
c
         manse0 = manse1 
         nman0  = nman1
         do iz         = 1,nman0
            depma0(iz) = depma1(iz)
            conma0(iz) = conma1(iz)
            temma0(iz) = temma1(iz)
         enddo   
c
c Nieuwe handmeting "1":
c
         read (lunman,fmt1,iostat=iocond) date,hhman,nmanx
c
         if (iocond.ne.0) then
            endman = .true.
            close(lunman)
            goto 8888
         else
            read(hhman(1:2),'(i2)') nhour
            read(hhman(3:4),'(i2)') nmin
            read(hhman(5:6),'(i2)') nsec         
c
c Nieuwe handmeting "1":
c
            nman1  = nmanx
            manse1 = nsec+60*(nmin+60*nhour)
            itdif  = manse1-nsecs(nrlmx)

            do in  = 1,nman1
               read(lunman,*) iz,depma1(iz),conma1(iz),temma1(iz)
            enddo   
         endif 
c Lees eventueel verder:
      if (itdif.lt.0) goto 33
      endif
c-----------------------------------------------------------------------
c Bepaal zoutgehalte en dichtheid uit metingen en calibratie,
c interpoleer lineair in de tijd, vermijd extrapolatie als voorbij
c laatste handmeting wordt gerekend, zie truncaties in gewichtsfactor W1:     
c-----------------------------------------------------------------------
8888  continue
c
      mandif = max(1,manse1-manse0)
      w1     = float((nsecs(nrlmx)-manse0))/mandif
      w1     = max(0.0,min(1.0,w1))
      w0     = 1.0-w1
c
c Maximaal aantal verticale meetdiepten: 
c
      nman   = max(nman0,nman1) 
c

c Ondergrens met gelijke diepten onder wateroppervlak, zie ook 
c toelichting in kop van deze subroutine:
c
      nmin   = 1+abs(nman0-nman1) 
c      
c Interpolatie in tijd tussen punten op gelijke diepte onder wateropp.,
c pas definitie teller aflopend vanaf hoogste positie (grootste IZ):
c
      do iz         = nmin,nman
         iz1        = iz+nman1-nman
         iz0        = iz+nman0-nman
         depman(iz) = w1*depma1(iz1)+w0*depma0(iz0)
         conman(iz) = w1*conma1(iz1)+w0*conma0(iz0)
         temman(iz) = w1*temma1(iz1)+w0*temma0(iz0)
      enddo 
c
c Aanvullen met diepste metingen die in een=1 van beide
c handmetingen voorkwam:
c
      if (nman0.lt.nman1) then
         do iz = 1,nmin-1
            depman(iz) = depma1(iz)
            conman(iz) = conma1(iz)
            temman(iz) = temma1(iz)
         enddo 
      elseif (nman0.gt.nman1) then
         do iz = 1,nmin-1
            depman(iz) = depma0(iz)
            conman(iz) = conma0(iz)
            temman(iz) = temma0(iz)
         enddo 
      else          
      endif
c-----------------------------------------------------------------------
c Zet diepte onder wateroppervlak DEPMAN om in diepte boven kolkbodem ;
c voer in calibratie handmeter:
c-----------------------------------------------------------------------       
      do iz         = 1,nman
         depman(iz) = max(0.0,hwz-depman(iz))
         conman(iz) = yokoga*conman(iz)
         salman(iz) = salin (temman(iz),conman(iz))
         rhoman(iz) = densit(temman(iz),salman(iz))       
      enddo   
c----------------------------------------------------------------------- 
c Gemiddelde saliniteit SALWZ en dichtheid RHOWZ in zee-voorhaven:
c----------------------------------------------------------------------- 
      dz     = depman(1)+0.5*(depman(2)-depman(1))
      ztot   = dz
      rhowz  = rhoman(1)*dz
      salwz  = salman(1)*dz      
c
      do iz    = 2,nman-1
         dz    = 0.5*(depman(iz+1)-depman(iz-1))
         ztot  = ztot+dz
         rhowz = rhowz+rhoman(iz)*dz
         salwz = salwz+salman(iz)*dz
      enddo
      dz       = hwz-0.5*(depman(nman)+depman(nman-1))
      ztot     = ztot+dz
      rhowz    = rhowz+rhoman(nman)*dz
      salwz    = salwz+salman(nman)*dz
c      
      rhowz    = rhowz/ztot
      salwz    = salwz/ztot     
c----------------------------------------------------------------------- 
c Vul dummy waarden in voor IX=1 zodat de rest van de berekening hiermee
c kan werken, merk op een keuze uit 5 posities nl bovenste 4 copieren
c en onderste altijd toekennen aan positie iz=1:
c----------------------------------------------------------------------- 
      ix = 1
c
      salt(ix,1) = 0.0
      rho (ix,1) = 0.0
c
      do iz          = 2,min(5,nman)
         salt(ix,iz) = salman(iz) 
         rho (ix,iz) = rhoman(iz)
         zpos(ix,iz) = depman(iz)
         salt(ix,1 ) = max(salt(ix,1),salt(ix,iz))
         rho (ix,1 ) = max(rho (ix,1),rho (ix,iz)) 
      enddo
c++   salt(ix,1) = salman(1)
c++   rho (ix,1) = rhoman(1) 
      zpos(ix,1) = depman(1)      
c
      return
      end
