      subroutine plclog (timnow,zmassa,signam,signal,nplcs,
     +                   volklk, 
     +                   salwz ,salklk,salijm,
     +                   rhowz ,rhoklk,rhoijm             )

c         D e l t a r e s  -   Unit: Deltares Software Centre
c
c             Module: subroutine PLCLOG
c           Function: PLC- logboek stand deuren en schuiven
c                     vertaald naar status schutproces, schrijven
c                     naar kanaal LUNPLC.
c
c-----------------------------------------------------------------------
c In PC04 staan de volgende PLC-signaalnamen gevolgd door hun status (0 of 1): 
c
c   1 ESO-WZ-D1  
c   2 ESD-WZ-D1
c
c   3 ESO-WZ-D2  
c   4 ESD-WZ-D2
c
c   5 ESO-WZ-D3  
c   6 ESD-WZ-D4
c
c   7 ESO-WZ-D4  
c   8 ESD-WZ-D4
c
c   9 ESO-IJM-D9 
c  10 ESD-IJM-D9
c
c  11 ESO-IJM-D10
c  12 ESD-IJM-D10
c
c  13 ESO-IJM-D11
c  14 ESD-IJM-D11
c
c  15 ESO-IJM-D12
c  16 ESD-IJM-D12
c
c  17 ESO-WZ-RK-D1  
c  18 ESD-WZ-RK-D1
c
c  19 ESO-WZ-RK-D2  
c  20 ESD-WZ-RK-D2
c
c  21 ESO-WZ-RK-D3  
c  22 ESD-WZ-RK-D4
c
c  23 ESO-WZ-RK-D4  
c  24 ESD-WZ-RK-D4
c
c  25 ESO-IJM-RK-D9 
c  26 ESD-IJM-RK-D9
c
c  27 ESO-IJM-RK-D10
c  28 ESD-IJM-RK-D10
c
c  29 ESO-IJM-RK-D11
c  30 ESD-IJM-RK-D11
c
c  31 ESO-IJM-RK-D12
c  32 ESD-IJM-RK-D12
c
c 33  LC-WZ-stop 
c 34  LC-WZ-half 
c 35  LC-WZ-Full
c
c 36  LC-IJM-stop 
c 37  LC-IJM-half 
c 38  LC-IJM-Full
c
c-----------------------------------------------------------------------
c
c        Method used: aanroep door programma STEVIN
c               Date: 10-05-2010
c         Programmer: R.E. Uittenbogaard
c************************************************************************
      include      'pardef.inc'
      include      'timefr.inc' 
      include      'hydarr.inc'  
      include      'physco.inc'        
      include      'units.inc'
c
      dimension     nplcs (20,38),isplc(38),
     +              signal(20,38) 
c
      character*15  signam(20,38),local(38)
      character*25  status(38)   
      character*25  cval  (38)
      character*99  fmt1,fmt2,fmt3,fmt4,fmt5
c
      character     datna0*8,hhmms0*6,
     +              datopn*8,timopn*6,
     +              datclo*8,timclo*6,
     +               getij*6, schut*4,
     +              eddeur*6
c
c Voor blokvorm in plot over schut-status, bewaar oude status
c datum en tijd:
c
      save          ifirst,datna0,hhmms0,
     +              xstwz0,xstij0,zmass0,
     +              nwz0  ,nijm0 ,
     +              nbwz0 ,nbijm0,
     +              xbstw0,xbsti0,
     +              frlwz0,frlij0,
     +              frswz0,frsij0,
     +              frwwz0,
     +              zmas0 ,zmas1 ,   
     +              timno0,topen ,tclose ,
     +              datopn,timopn,
     +              salopn,rhoopn,
     +              datclo,timclo,
     +              nlzee ,nlmeer    
c
      data          
     + fmt1/'(a8,1x,a6,9(1x,f4.2),3x,2(1x,a12,1x,a15,1x,a23),1x,a23)'/    
c          
     + fmt2/'(a8,1x,a6,7(3x,f7.3),1x,i6)'/    
c        
     + fmt3/'(a8,4(1x,a6),1x,f7.1,3(1x,f7.0))'/         
c
     + fmt4/'(a8,1x,a6,6(3x,f7.3),1x,i6)'/    
c
     + fmt5/'(a8,1x,a6,7(3x,f7.3),1x,i6)'/    

c        
      data          ifirst/0/,tollvl/0.03/,
     +              belmin/10.0/,belmax/250.0/,
     +              watmin/10.0/,watmax/999.0/,     
     +              xnoval/999.999/,froumx/9.99/,
     +              riwzmx/2200.15/,riijmx/2315.98/
c
c Tekst voor controle op status-indicatoren:
c
      data          status( 1)/'Zee  = Open '/,
     +              status( 2)/'Zee  = Dicht'/,  
     +              status( 3)/'Meer = Open '/, 
     +              status( 4)/'Meer = Dicht'/  
c
      data          status( 5)/'RK-Zee  = Open '/,
     +              status( 6)/'RK-Zee  = Dicht'/,  
     +              status( 7)/'RK-Meer = Open '/, 
     +              status( 8)/'RK-Meer = Dicht'/  
c
      data          status( 9)/'Vullen Kolk uit Zee   '/,
     +              status(10)/'Ledigen Kolk naar Zee '/,
     +              status(11)/'Vullen Kolk uit Meer  '/,
     +              status(12)/'Ledigen Kolk naar Meer'/     
c
      data          status(13)/'Deltares-scherm Zee   '/,
     +              status(14)/'Deltares-scherm Meer  '/
c
      data          status(15)/'Stevin-zee-scherm Half'/,
     +              status(16)/'Stevin-zee-scherm Vol '/
c
      data          status(17)/'Stevin-meer-scherm Half'/,
     +              status(18)/'Stevin-meer-scherm Vol '/
c      
c-----------------------------------------------------------------------
c Initialiseer character-regels voor uitvoer:
c-----------------------------------------------------------------------
      do i         = 1,38
         cval  (i) = ' ' 
      enddo
c-----------------------------------------------------------------------
c Maak inhoudsopgave van bestand STATUS.tek en info voor plotten:
c-----------------------------------------------------------------------
      if (ifirst.eq.0) then
          nlzee  = 0
          nlmeer = 0
c          
          xstwz0 = 0
          xstij0 = 0
          datna0 = datnam
          hhmms0 = hhmmss
c
          timno0 = timnow
          topen  = timnow
          tclose = timnow
c
          datopn = datnam
          datclo = datnam
          timopn = hhmmss
          timclo = hhmmss
c
          zmass0 = zmassa
          zmas0  = zmassa
          zmas1  = zmassa
c          
          nwz0   = 1
          nijm0  = 1     
c
          xbstw0 = 0.0    
          xbsti0 = 0.0   
c
          frlwz0 = 0.0
          frlij0 = 0.0
c
          frswz0 = 0.0
          frsij0 = 0.0
c
          nbwz0  = 0
          nbijm0 = 0
c
          frwwz0 = 0.0 
c
          ifirst = 1
          lun    = lunplc
c-----------------------------------------------------------------------
c File header voor STATUS.tek status van schutproces :
c-----------------------------------------------------------------------
          write(lun,'(a)') '*'
          write(lun,'(a)')
     +   '* Status schutproces:'
          write(lun,'(a)') '*'
          write(lun,'(a)')
     +   '* kolom  1: jaar/maand/dag                    [datum]'
          write(lun,'(a)')
     +   '* kolom  2: uur/min/sec                       [datum]'     
          write(lun,'(a)')
     +   '* kolom  3: indicator kolk open zeezijde          [-]'
          write(lun,'(a)') 
     +   '* kolom  4: indicator kolk open meerzijde         [-]'
          write(lun,'(a)') 
     +   '* kolom  5: Froude-L  Stevin-scherm zeezijde      [-]'
          write(lun,'(a)') 
     +   '* kolom  6: Froude-L  Stevin-scherm meerzijde     [-]'
          write(lun,'(a)') 
     +   '* kolom  7: Froude-L  Detares-scherm zeezijde     [-]'
          write(lun,'(a)') 
     +   '* kolom  8: Froude-L  Deltares-scherm meerzijde   [-]'
          write(lun,'(a)') 
     +   '* kolom  9: Froude-W  Water-scherm zeezijde       [-]'
          write(lun,'(a)') 
     +   '* kolom 10: fractie opening rinket zee-zijde      [-]'
          write(lun,'(a)') 
     +   '* kolom 11: fractie opening rinket meer-zijde     [-]'
          write(lun,'(a)') 
     +   '* kolom  ?: Tekst status                          [-]'
c
          write(lun,'(a)') '*'
c Twee datum & tijd kolommen en 2 kolommen met open naar zee/meer
c indicatoren:
          nco   = 11
c
c Dubbele tijdregels voor plotten status in blokvorm:
c
          n2time = 2*linemx
c          
          dummy = 'plc'
          write(lun,'(a)'        ) dummy
          write(lun,'(2(1x,i10))') n2time,nco  
c-----------------------------------------------------------------------
c Maak inhoudsopgave van bestand 2ZEE.tek voor analyse zoutvracht tussen
c kolk en zee-voorhaven en info voor plotten:
c-----------------------------------------------------------------------
          lun    = lunzee
c
c File header voor 2ZEE.tek zouttransport:
c
          write(lun,'(a)') '*'
          write(lun,'(a)')
     +   '* Analyse schutten zee-voorhaven <> kolk:'
          write(lun,'(a)') '*'
          write(lun,'(a)')
     +   '* kolom  1: jaar/maand/dag                    [datum]'
          write(lun,'(a)') 
     +   '* kolom  2: uur/min/sec                       [datum]'     
          write(lun,'(a)')
     +   '* kolom  3: zoutmassa bij openen kolk           [ton]'
          write(lun,'(a)') 
     +   '* kolom  4: zoutmassa bij sluiten kolk          [ton]'
          write(lun,'(a)')
     +   '* kolom  5: theoretische zoutmassa bij sluiten  [ton]'
          write(lun,'(a)')
     +   '* kolom  6: geschatte reductie                    [%]'
          write(lun,'(a)') 
     +   '* kolom  7: Froude-L  Stevin-scherm zeezijde      [-]'
          write(lun,'(a)') 
     +   '* kolom  8: Froude-L  Deltares-scherm zeezijde    [-]'
          write(lun,'(a)') 
     +   '* kolom  9: Froude-W  Water-scherm zeezijde       [-]'
          write(lun,'(a)')
     +   '* kolom 10: regel teller                          [-]'
          write(lun,'(a)') '*'
          nco   = 10
c Ad-hoc: aantal is vooraf onbekend:
          nlin  = 56             
          dummy = 'log'
          write(lun,'(a)'        ) dummy
          write(lun,'(2(1x,i10))') nlin,nco
c-----------------------------------------------------------------------
c Maak inhoudsopgave van bestand 2ZEE.tek voor analyse zoutvracht tussen
c kolk en zee-voorhaven en info voor plotten:
c-----------------------------------------------------------------------
          lun    = lunmee
c
c File header voor 2MEER.tek zouttransport:
c
          write(lun,'(a)') '*'
          write(lun,'(a)')
     +   '* Analyse schutten meer-voorhaven <> kolk:'
          write(lun,'(a)') '*'
          write(lun,'(a)')
     +   '* kolom  1: jaar/maand/dag                    [datum]'
          write(lun,'(a)') 
     +   '* kolom  2: uur/min/sec                       [datum]'     
          write(lun,'(a)')
     +   '* kolom  3: zoutmassa bij openen kolk           [ton]'
          write(lun,'(a)') 
     +   '* kolom  4: zoutmassa bij sluiten kolk          [ton]'
          write(lun,'(a)')
     +   '* kolom  5: theoretische zoutmassa bij sluiten  [ton]'
          write(lun,'(a)')
     +   '* kolom  6: geschatte reductie                    [%]'
          write(lun,'(a)') 
     +   '* kolom  7: Froude-L  Stevin-scherm meerzijde     [-]'
          write(lun,'(a)') 
     +   '* kolom  8: Froude-L  Deltares-scherm meerzijde   [-]'     
          write(lun,'(a)')
     +   '* kolom  9: Zoutverlies naar IJsselmeer         [ton]'     
          write(lun,'(a)')
     +   '* kolom 10: regel teller                          [-]'
          write(lun,'(a)') '*'
          nco   = 10
c Ad-hoc: aantal is vooraf onbekend:
          nlin  = 56       
          dummy = 'log'
          write(lun,'(a)'        ) dummy
          write(lun,'(2(1x,i10))') nlin,nco    
c Maak inhoudsopgave van bestand 2ZEE.tek voor analyse zoutvracht tussen
c kolk en zee-voorhaven en info voor plotten:
c-----------------------------------------------------------------------
          lun    = lunana
c
c File header voor LOGBOEK.tek logboek van deze dag:
c
          write(lun,'(a)') '*'
          write(lun,'(a)')
     +   '* Logboek schutten naar Waddenzee of Ijsselmeer:'
          write(lun,'(a)') '*'
          write(lun,'(a)')
     +   '* kolom  1: jaar/maand/dag sluiten            [datum]'
          write(lun,'(a)') 
     +   '* kolom  2: uur/min/sec sluiten deur          [datum]'     
          write(lun,'(a)')
     +   '* kolom  3: getijfase                             [-]'
          write(lun,'(a)') 
     +   '* kolom  4: schutten naar zee of meer             [-]'
          write(lun,'(a)')
     +   '* kolom  5: lekkende ebdeuren                     [-]'
          write(lun,'(a)')
     +   '* kolom  6: opentijd                            [min]'
          write(lun,'(a)') 
     +   '* kolom  7: Debiet Stevinsluis-bellenscherm    [Nl/s]'
          write(lun,'(a)') 
     +   '* kolom  8: Debiet Deltares-bellenscherm       [Nl/s]'     
          write(lun,'(a)')
     +   '* kolom  9: Debiet Deltares-waterscherm         [l/s]'
          write(lun,'(a)') '*'
          nco   = 9 
c Ad-hoc: aantal is vooraf onbekend:
          nlin  = 56       
          dummy = 'log'
          write(lun,'(a)'        ) dummy
          write(lun,'(2(1x,i10))') nlin,nco    
      endif          
c----------------------------------------------------------------------
c Voor inspectie met debugger, kopieer namen en logic-control variabelen
c naar 1D-arrays:
c----------------------------------------------------------------------
      npc = 4
      do is        = 1,38
         local(is) = signam(npc,is)
         isplc(is) = nplcs (npc,is) 
      enddo
c----------------------------------------------------------------------
c Deur open signaal, combineer eb- en vloeddeuren per zoet/zout zijde,
c controleer met 1 van de 2 deuren per set vloed- en ebdeuren.
c Het is mogelijk dat zowel eb- als vloeddeuren gesloten zijn, trunceer
c daarom NWZ of NIJM tot hooguit NWZ/NIJM=1 i.v.m. besliscriteria voor 
c openen/sluiten kolk.
c----------------------------------------------------------------------
      nwz   = min(1,isplc( 1)+isplc( 5))
      nijm  = min(1,isplc( 9)+isplc(13))
c----------------------------------------------------------------------
c rinketschuiven zee- en meer-zijde open signaal:
c----------------------------------------------------------------------
      nrwz  = isplc(17)*isplc(19)+isplc(21)*isplc(23)     
      nrijm = isplc(25)*isplc(27)+isplc(29)*isplc(31)            
c----------------------------------------------------------------------
c partiele opening rinketschuiven = lekkende ebdeuren:
c----------------------------------------------------------------------
c
c Zee-zijde:
c
      rkd3   = signal(9,5) 
      rkd4   = signal(2,8)
c Schalen met maximale opening en klippen: 
      rinwz  = (rkd3+rkd4)/riwzmx  
      rinwz  = max(0.0,min(1.0,rinwz))
c
c Meer-zijde:
c
      rkd11  = signal(9,6)
      rkd12  = signal(6,5)
c Schalen naar maximale opening en klippen: 
      rinijm = (rkd11+rkd12)/riijmx
      rinijm = max(0.0,min(1.0,rinijm))
c----------------------------------------------------------------------
c Originele Stevinsluis bellenschermen aan zee-zijde:
c
c XBSTWZ : Nummer-Bellenscherm-STevin-WaddenZee
c
c XBSTWZ = 0  geen lucht
c XBSTWZ = 1  half vermogen
c XBSTWZ = 2  vol vermogen
c
c----------------------------------------------------------------------
      xbstwz     = 0.0
      if (   isplc(35).eq.1 .and. isplc(34).eq.1) then
         xbstwz  = 1.0
         cval(7) = status(15)
      elseif(isplc(35).eq.1 .and. isplc(34).eq.0) then
         xbstwz = 2.0
         cval(7) = status(16)         
      else
      endif   
c----------------------------------------------------------------------
c Originele Stevinsluis bellenschermen aan meer-zijde:
c
c XBSTIJ : Nummer-Bellenscherm-STevin-IJsselmeer
c
c XBSTIJ = 0  geen lucht
c XBSTIJ = 1  half vermogen
c XBSTIJ = 2  vol vermogen
c
c----------------------------------------------------------------------
      xbstij    = 0.0
      if (   isplc(38).eq.1 .and. isplc(37).eq.1) then
         xbstij = 1.0
         cval(7) = status(17)
      elseif(isplc(38).eq.1 .and. isplc(37).eq.0) then
         xbstij = 2.0
         cval(7) = status(18)         
      else
      endif   
c----------------------------------------------------------------------
c Bepaal luchtdebieten (Nliter/sec) Stevinsluis-bellenschermen op basis 
c van half/vol vermogen compressor indicatoren (XBSTWZ en XBSTIJ) per 
c zee-/meerzijde. Vol vermogen levert BELMAX Nliter/sec lucht:
c----------------------------------------------------------------------
      belwz  = xbstwz*belmax/2
      belijm = xbstij*belmax/2
c

      belswz = belwz
      belsij = belijm
c
c FRSWZ = Froude-lucht getal Stevinsluis-bellenscherm aan Waddenzee-zijde:
c        
      etta   = 1.0        
      hlex   = hkolk-hdremp
c      
      call lockex(salwz ,salklk,rhowz ,rhoklk,etta  ,
     +            cwav  ,hlex  ,hlex  ,volflx,salflx)
c
      qa     = belwz/(1e3*bvloer)
      power  = 1./3.
      frswz  = ((ag*qa)**power)/max(1e-3,cwav)
c
c Clip voor te hoge waarden, niet relevant:      
c
      frswz = min(froumx,frswz)

c FRSIJM = Froude-lucht getal Stevinsluis-bellenscherm aan IJsselmeer-zijde:
c       
      etta   = 1.0        
      hlex   = hkolk-hdremp
c      
      call lockex(salklk,salijm,rhoklk,rhoijm,etta  ,
     +            cwav  ,hlex  ,hlex  ,volflx,salflx)
c
      qa     = belijm/(1e3*bvloer)
      power  = 1./3.
c
      frsijm = ((ag*qa)**power)/max(1e-3,cwav)
c
c Clip voor te hoge waarden, niet relevant:      
c
      frsijm = min(froumx,frsijm)      
c----------------------------------------------------------------------
c Deltares_bellenschermen aan:
c----------------------------------------------------------------------
c
c Sommeer luchtdebieten (liter/sec) per zee-/meerzijde:
c
      belwz  = signal(2,5)+signal(2,6)
      belijm = signal(6,2)+signal(6,3)
c
      beldwz = belwz
      beldij = belijm
c
      nbwz   = 0
      nbijm  = 0
c
      frlwz  = 0.0
      frlijm = 0.0
c----------------------------------------------------------------------
c Bellenscherm aan dan NBWZ=1 en bereken Froude-lucht-getal. Let op,
c dit Froude-getal wordt gebaseerd op de actuele dichtheid i.t.t.
c de theoretische schatting van de zoutmassa-verandering:
c----------------------------------------------------------------------
      if(belwz.gt.belmin) then
         nbwz   = 1
c        
         etta   = 1.0        
         hlex   = hkolk-hdremp
         call lockex(salwz ,salklk,rhowz ,rhoklk,etta  ,
     +               cwav  ,hlex  ,hlex  ,volflx,salflx)
c
         qa     = belwz/(1e3*bvloer)
         power  = 1./3.
c
c FRLWZ = Froude-lucht getal Deltares-bellenschermen aan Waddenzee-zijde:
c
         frlwz  = ((ag*qa)**power)/max(1e-3,cwav)
c
c Clip voor te hoge waarden, niet relevant:      
c
         frlwz = min(froumx,frlwz)
      endif
      if(belijm.gt.belmin) then
         nbijm   = 1
c
c FRLIJM = Froude-lucht IJsselmeer-zijde:
c
         etta    = 1.0   
         hlex   = hkolk-hdremp
c         
         call lockex(salklk,salijm,rhoklk,rhoijm,etta  ,
     +               cwav  ,hlex  ,hlex  ,volflx,salflx)
c
         qa     = belijm/(1e3*bvloer)
         power  = 1./3.
         frlijm = ((ag*qa)**power)/max(1e-3,cwav)
c
c Clip voor te hoge waarden, niet relevant:      
c
         frlijm = min(froumx,frlijm)
      endif      
c----------------------------------------------------------------------
c Deltares_waterschermen aan:
c----------------------------------------------------------------------
c
c Sommeer waterdebieten (liter/sec) alleen aan zeezijde:
c
      watwz  = signal(2,1)+signal(2,3)+signal(9,1)+signal(9,3)
c      
      frwwz  = 0.0
c----------------------------------------------------------------------
c Waterscherm bereken Froude-water-getal. Let op,
c dit Froude-getal wordt gebaseerd op de actuele dichtheid i.t.t.
c de theoretische schatting van de zoutmassa-verandering:
c----------------------------------------------------------------------     
      if(watwz.gt.watmin) then       
         etta   = 1.0        
         hlex   = hkolk-hdremp
         call lockex(salwz ,salklk,rhowz ,rhoklk,etta  ,
     +               cwav  ,hlex  ,hlex  ,volflx,salflx)
c
         qw     = watwz/(1e3*bvloer)
         power  = 1./3.
c
c FRWWZ = Froude-water getal Deltares-waterschermen aan Waddenzee-zijde:
c
         frwwz  = ((ag*qw)**power)/max(1e-3,cwav)
c
c Clip voor te hoge waarden, niet relevant:      
c
         frwwz = min(froumx,frwwz)
      endif
c----------------------------------------------------------------------
c De status indicatoren voor plotten in tijdreeks:
c
c XSTWZ  (Status zijde Waddenzee):  0.0 gesloten deuren zoute zijde
c                                   1.0 geopende rinketschuiven zoute zijde
c                                   2.0 geopende deuren zoute zijde. 
c
c Deze logica maar met een kleine off-set (0.1) om geen overlap in plot
c van blokvormen met zoutez-ijde signalen te krijgen: 
c
c XSTIJM (Status zijde IJsselmeer): 0.1  gesloten deuren zoete zijde
c                                   1.1  geopende rinketschuiven zoete zijde
c                                   2.1  geopende deuren zoete zijde. 
c
c----------------------------------------------------------------------
c
c Kolk wel/niet open naar zee:
c
      if (nwz.eq.0) then
          xstwz   = 2.0
          cval(1) = status(1)
      else 
          cval(1) = status(2)
c
c Zee-rinketschuiven open/dicht:
c
          if (nrwz.eq.0) then
              xstwz   = 1.0
              cval(2) = status(5)
c
c Vullen uit of ledigen naar zee:
c
              hkolkp = hkolk+tollvl
c              
              if (hwz.gt.hkolkp) then
                 cval(3) = status(9)
              else
                 cval(3) = status(10)
              endif   
          else
              xstwz   = 0.0
              cval(2) = status(6)
          endif    
      endif
c----------------------------------------------------------------------
c Kolk wel/niet open naar meer:
c----------------------------------------------------------------------
      if (nijm.eq.0) then
          xstijm  = 2.0
          cval(4) = status(3)
      else 
          cval(4) = status(4)
c
c Meer-rinketschuiven open/dicht:
c
          if (nrijm.eq.0) then
              xstijm  = 1.0
              cval(5) = status(7)
c
c Vullen uit of ledigen naar meer:
c
              if (hkolk.gt.tollvl) then
                 cval(6) = status(12)
              else
                 cval(6) = status(11)
              endif   
              
          else
              xstijm  = 0.0
              cval(5) = status(8)
          endif    
      endif
c
      offset = 0.1
      xstijm = xstijm+offset
c----------------------------------------------------------------------
c Schrijven voor plotten in blokvorm via bestand STATUS.tek:
c----------------------------------------------------------------------
c
      nc = 7 
      write(lunplc,fmt1)
     + datna0,hhmms0,xstwz0,xstij0,frswz0,frsij0,frlwz0,frlij0,
     + frwwz0,rinwz ,rinijm,(cval(j),j=1,nc)
c     
      write(lunplc,fmt1)
     + datnam,hhmmss,xstwz ,xstijm,frswz ,frsijm,frlwz ,frlijm,
     + frwwz ,rinwz ,rinijm,(cval(j),j=1,nc)      
c----------------------------------------------------------------------
c Voorbeeld/Analyse zoutuitwiseling zeezijde, uitvoer naar 2ZEE.tek:
c----------------------------------------------------------------------
      n2wz = 0
c 
c Controleer op verandering NWZ van dicht (1) naar open (0).
c En onthoud vanaf het moment van het openen van de sluisdeur het 
c gemiddelde zoutgehalte (SALOPN) en dichtheid (RHOOPN) in de kolk
c voor de theoretische analyse van zouttransport:
c
      if (nwz.lt.nwz0) then
         topen  = timno0
         datopn = datna0
         timopn = hhmms0
         salopn = salklk
         rhoopn = rhoklk
         zmas0  = zmass0
      endif
c 
c Controleer op verandering NWZ van open (0) naar dicht (1):
c     
      if(nwz.gt.nwz0) then
         tclose = timno0
         datclo = datna0
         timclo = hhmms0        
         zmas1  = zmass0
         n2wz   = 1
      endif
c----------------------------------------------------------------------
c N2WZ=1 betekent cyclus afgerond van open/dicht kolk naar Waddenzee:
c----------------------------------------------------------------------
      if (n2wz.eq.1) then
         n2ijm  = 0
         diftim = tclose-topen
c
c Theoretische fluxen volgens LOCKEX-formules. Zonder reductie (ETTA) 
c van bellenscherm, houd rekening met drempelhoogte:
c
         etta   = 1.0      
         hlex   = hkolk-hdremp

c Theoretisch zouttransport gebaseerd op situatie in kolk op moment van
c openen van de sluisdeuren (SALOPN en RHOOPN):
             
         call lockex(salwz ,salopn,rhowz ,rhoopn,etta  ,
     +               cwav  ,hlex  ,hlex  ,volflx,salflx)
c
c Controleer of meer dan 80% van het kolkvolume is uitgewisseld:
c
         vulmax = 0.8*volklk 
c++      vulmax = 1.0*volklk          
         vollex = volflx*bvloer*diftim
         volmax = min(vollex,vulmax)
c     
c Theoretische schatting nieuwe zoutmassa t.o.v. zoutmassa
c ZMAS0 op het moment dat de kolk sloot:
c
         zmas2  = zmas0+(salwz-salopn)*volmax
c
c Er kan niet meer zout in dan (80%?) kolk volume met zoutgehalte 
c Waddenzee kan bergen:
c
c++      zmas3  = salwz*volklk
         zmas3  = salwz*vulmax
         if (zmas2.gt.zmas3) then
            zmas2 = zmas3
         endif   
c
c Bijdrage door b.v. zwaaien van deuren of in-/uitgaande
c scheepvaart:
c
c++      vschip = ??
c++      zmas2  = zmas2+vschip*(salwz-salklk)
c----------------------------------------------------------------------
c Schrijven naar 2ZEE.tek:
c----------------------------------------------------------------------
c
         nc     = 6
         nlzee  = nlzee+2
c
c Zoutmassa's in [ton]:
c
         zmas0  = zmas0/1000.
         zmas1  = zmas1/1000.
         zmas2  = zmas2/1000.
c
c Reductie in %: 
c
         difobs = zmas1-zmas0
         difana = zmas2-zmas0
         reduc  = 100*difobs/max(1.0,difana)
         reduc  = max(0.0,min(reduc,999.))
c
         write(lunzee,fmt2)
     +   datopn,timopn,zmas0 ,xnoval,xnoval,reduc ,
     +   frswz0,frlwz0,frwwz0,nlzee
c     
         write(lunzee,fmt2)
     +   datclo,timclo,xnoval,zmas1 ,zmas2 ,reduc ,
     +   frswz ,frlwz ,frwwz ,nlzee          
c----------------------------------------------------------------------
c Naar Logboek voor overzicht - schutten naar Waddenzee:
c----------------------------------------------------------------------
         topen  = diftim/60.
         nkeer  = nlzee/2         
         schut  = 'Zee '
         ebdeur = '       '
c
         if (belswz.lt.belmin) belswz = 0.0
         if (beldwz.lt.belmin) beldwz = 0.0
         if (watwz .lt.belmin) watwz  = 0.0
c
c Getijfase afhankelijk van marge HKENT:
c
         hdif  = hwz-hijm
         hkent = 0.3
         if (abs(hdif).lt. hkent) then
            getij = 'Kenter'
         elseif   (hdif.gt.hkent) then
            getij = 'Vloed '        
         else
            getij = 'Eb    '       
c Lekkende ebdeuren:
           if (rinijm.gt.0.05) ebdeur = 'LekEbd'
         endif
c         
         write(lunana,fmt3)
     +   datclo,timclo,getij,schut,ebdeur,topen,
     +   belswz,beldwz,watwz 
c
      endif
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c Voorbeeld/Analyse zoutuitwiseling meerzijde, uitvoer naar 2MEER.tek:
c----------------------------------------------------------------------
c----------------------------------------------------------------------
      n2ijm = 0
c 
c Controleer op verandering NIJM van dicht (1) naar open (0).
c En onthoud vanaf het moment van het openen van de sluisdeur het 
c gemiddelde zoutgehalte (SALOPN) en dichtheid (RHOOPN) in de kolk
c voor de theoretische analyse van zouttransport:
c
      if (nijm.lt.nijm0) then
         topen  = timno0
         datopn = datna0
         timopn = hhmms0
         salopn = salklk
         rhoopn = rhoklk 
         zmas0  = zmass0
      endif
c 
c Controleer op verandering NIJM van open (0) naar dicht (1).
c     
      if(nijm.gt.nijm0) then
         tclose = timno0
         datclo = datna0
         timclo = hhmms0        
         zmas1  = zmass0
         n2ijm  = 1
      endif
c----------------------------------------------------------------------
c N2IJM=1 betekent cyclus afgerond van open/dicht kolk naar IJsselmeer:
c----------------------------------------------------------------------
      if (n2ijm.eq.1) then
         n2wz   = 0  
         diftim = tclose-topen
c
c Theoretische fluxen volgens LOCKEX-formules:
c
         etta   = 1.0
         hlex   = hkolk-hdremp
c
c Theoretisch zouttransport gebaseerd op situatie in kolk op moment van
c openen van de sluisdeuren (SALOPN en RHOOPN):
c
         call lockex(salopn,salijm,rhoopn,rhoijm,etta  ,
     +               cwav  ,hlex  ,hlex  ,volflx,salflx)
c
c Controleer of meer dan 100% van het kolkvolume is uitgewisseld:
c
         vulmax = 0.8*volklk 
         vollex = volflx*bvloer*diftim
         volmax = min(vollex,vulmax)
c     
c Theoretische schatting nieuwe zoutmassa t.o.v. zoutmassa
c ZMAS0 op het moment dat de kolk sloot:
c
         zmas2  = zmas0-(salopn-salijm)*volmax
c
c De minimale zoutmassa in de kolk is het (80%) kolkvolume met 
c het zoutgehalte IJsselmeerzijde kan bergen:
c
c++      zmas3  = salwz*volklk
         zmas3  = salijm*vulmax
         if (zmas2.lt.zmas3) then
            zmas2 = zmas3
         endif            
c
c Bijdrage door b.v. zwaaien van deuren of in-/uitgaande
c scheepvaart:
c
c++      vschip = ???      
c++      zmas2  = zmas2-vschip*(salwz-salklk)
c----------------------------------------------------------------------
c Schrijven naar 2MEER.tek:
c----------------------------------------------------------------------
c         
         nlmeer  = nlmeer+2
c
c Zoutmassa's in [ton]:
c
         zmas0  = zmas0/1000.
         zmas1  = zmas1/1000.
         zmas2  = zmas2/1000.     
c
c Zoutverlies naar IJsselmeer-voorhaven:
c
         zmas01 = zmas0-zmas1
         zmas00 = 0.0
c
c Reductie in %: 
c
         difobs = zmas0-zmas1
         difana = zmas0-zmas2
         reduc  = 100*difobs/max(1.0,difana)
         reduc  = max(0.0,min(reduc,999.))
c
         write(lunmee,fmt5)
     +   datopn,timopn,zmas0 ,xnoval,xnoval,reduc ,
     +   frsij0,frlij0,zmas00,nlmeer 
c     
         write(lunmee,fmt5)
     +   datclo,timclo,xnoval,zmas1 ,zmas2 ,reduc ,
     +   frsijm,frlijm,zmas01,nlmeer     
c----------------------------------------------------------------------
c Naar Logboek voor overzicht - schutten naar IJsselmeer:
c----------------------------------------------------------------------
         topen  = diftim/60.
         nkeer  = nlmeer/2         
         schut  = 'Meer'
         ebdeur = '       '         
c
         if (belsij.lt.belmin) belsij = 0.0
         if (beldij.lt.belmin) beldij = 0.0
         watijm = 0.0              
c
c Getijfase afhankelijk van marge HKENT:
c
         hdif  = hwz-hijm
         hkent = 0.1
         if (abs(hdif).lt. hkent) then
            getij = 'Kenter'
         elseif   (hdif.gt.hkent) then
            getij = 'Vloed '         
         else
            getij = 'Eb    '       
c Lekkende ebdeuren:
           if (rinwz .gt.0.05) ebdeur = 'Lekken'
         endif
c               
         write(lunana,fmt3)
     +   datclo,timclo,getij,schut,ebdeur,topen,
     +   belsij,beldij,watijm
      endif      
c----------------------------------------------------------------------
c Onthoud laaste datum, tijd, status-indicatoren en zoutmassa:
c----------------------------------------------------------------------
      xstwz0 = xstwz
      xstij0 = xstijm
      datna0 = datnam
      hhmms0 = hhmmss
      timno0 = timnow
      zmass0 = zmassa
c
      nwz0   = nwz
      nijm0  = nijm
c
      nbwz0  = nbwz
      nbijm0 = nbijm
c
      xbstw0 = xbstwz
      xbsti0 = xbstij
c      
      frlwz0 = frlwz
      frlij0 = frlijm
c
      frswz0 = frswz
      frsij0 = frsijm
c
      frwwz0 = frwwz
c
      return
      end
