      subroutine plclog (timnow,zmassa,signam,signal,nplcs,
     +                   volklk,salwz ,salklk,salijm,
     +                   zmasth,rhowz ,rhoklk,rhoijm      )

c         D e l t a r e s  -   Unit: Deltares Software Centre
c
c             Module: subroutine PLCLOG
c           Function: PLC- logboek stand deuren en schuiven
c                     vertaald naar status schutproces, schrijven
c                     naar kanaal LUNPLC.
c
c-----------------------------------------------------------------------
c In PC04 staan de volgende PLC-signaalnamen gevolgd door hun status (0 of 1): 
c
c   1 ESO-WZ-D1  
c   2 ESD-WZ-D1
c
c   3 ESO-WZ-D2  
c   4 ESD-WZ-D2
c
c   5 ESO-WZ-D3  
c   6 ESD-WZ-D4
c
c   7 ESO-WZ-D4  
c   8 ESD-WZ-D4
c
c   9 ESO-IJM-D9 
c  10 ESD-IJM-D9
c
c  11 ESO-IJM-D10
c  12 ESD-IJM-D10
c
c  13 ESO-IJM-D11
c  14 ESD-IJM-D11
c
c  15 ESO-IJM-D12
c  16 ESD-IJM-D12
c
c  17 ESO-WZ-RK-D1  
c  18 ESD-WZ-RK-D1
c
c  19 ESO-WZ-RK-D2  
c  20 ESD-WZ-RK-D2
c
c  21 ESO-WZ-RK-D3  
c  22 ESD-WZ-RK-D4
c
c  23 ESO-WZ-RK-D4  
c  24 ESD-WZ-RK-D4
c
c  25 ESO-IJM-RK-D9 
c  26 ESD-IJM-RK-D9
c
c  27 ESO-IJM-RK-D10
c  28 ESD-IJM-RK-D10
c
c  29 ESO-IJM-RK-D11
c  30 ESD-IJM-RK-D11
c
c  31 ESO-IJM-RK-D12
c  32 ESD-IJM-RK-D12
c
c  33  LC-WZ-stop 
c  34  LC-WZ-half 
c  35  LC-WZ-Full
c
c  36  LC-IJM-stop 
c  37  LC-IJM-half 
c  38  LC-IJM-Full
c
c-----------------------------------------------------------------------
c
c        Method used: aanroep door programma STEVIN
c               Date: 18-05-2010
c         Programmer: R.E. Uittenbogaard
c************************************************************************
      include      'pardef.inc'
      include      'timefr.inc' 
      include      'hydarr.inc'  
      include      'physco.inc'        
      include      'units.inc'
c
      dimension     nplcs (20,38),isplc(38),
     +              signal(20,38),zval (20) 
c
      character*15  signam(20,38),local(38)
      character*25  status(38)   
      character*25  cval  (38)
      character*99  fmt1,fmt2,fmt2a,fmt3,fmt4,fmt4a
c
      character     datna0*8,hhmms0*6,
     +              datopn*8,timopn*6,
     +              datclo*8,timclo*6,
     +               getij*6, schut*4
c
c Voor blokvorm in plot over schut-status, bewaar oude status
c datum en tijd:
c
      save          ifirst,datna0,hhmms0,
     +              xstwz0,xstij0,
     +              nwz0  ,nijm0 ,
     +              xbstw0,xbsti0,
     +              frdwz0,frdij0,
     +              frswz0,frsij0,
     +              frwwz0,
     +              belswm,belsim,
     +              beldwm,beldim,
     +              watwzm, 
     +              zmas0 ,zmas1 ,   
     +              timno0,topen ,tclose ,
     +              datopn,timopn,
     +              salopn,rhoopn,
     +              datclo,timclo,
     +              nlzee ,nlmeer    
c
      data          
     + fmt1 /'(a8,1x,a6,9(1x,f4.2),3x,2(1x,a12,1x,a15,1x,a23),1x,a23)'/    
c          
     + fmt2 /'(a8,1x,a6,10(3x,f7.3),2(1x,f7.0))'/    
c          
     + fmt2a/'(a8,1x,a6,10(3x,f7.3),2(1x,f7.3))'/    
c        
     + fmt3 /'(a8,4(1x,a6),1x,f7.1,3(1x,f7.0),2(1x,f7.1))'/         
c
     + fmt4 /'(a8,1x,a6,13(3x,f7.3),3(1x,f7.0))'/    
c
     + fmt4a/'(a8,1x,a6,13(3x,f7.3),3(1x,f7.3))'/    
c        
      data          ifirst/0/,tollvl/0.03/,
     +              belmin/20.0/,belmax/168.0/,
     +              watmin/300.0/,frmin /0.01/,     
     +              xnoval/999.999/,
     +              riwzmx/2200.15/,riijmx/2315.98/
c
c Tekst voor controle op status-indicatoren:
c
      data          status( 1)/'Zee  = Open '/,
     +              status( 2)/'Zee  = Dicht'/,  
     +              status( 3)/'Meer = Open '/, 
     +              status( 4)/'Meer = Dicht'/  
c
      data          status( 5)/'RK-Zee  = Open '/,
     +              status( 6)/'RK-Zee  = Dicht'/,  
     +              status( 7)/'RK-Meer = Open '/, 
     +              status( 8)/'RK-Meer = Dicht'/  
c
      data          status( 9)/'Vullen Kolk uit Zee   '/,
     +              status(10)/'Ledigen Kolk naar Zee '/,
     +              status(11)/'Vullen Kolk uit Meer  '/,
     +              status(12)/'Ledigen Kolk naar Meer'/     
c
      data          status(13)/'Deltares-scherm Zee   '/,
     +              status(14)/'Deltares-scherm Meer  '/
c
      data          status(15)/'Stevin-zee-scherm Half'/,
     +              status(16)/'Stevin-zee-scherm Vol '/
c
      data          status(17)/'Stevin-meer-scherm Half'/,
     +              status(18)/'Stevin-meer-scherm Vol '/
c      
c-----------------------------------------------------------------------
c Initialiseer character-regels voor uitvoer:
c-----------------------------------------------------------------------
      do i         = 1,38
         cval  (i) = ' ' 
      enddo
c      
      if (ifirst.eq.0) then
          nlzee  = 0
          nlmeer = 0
c          
          xstwz0 = 0
          xstij0 = 0
          datna0 = datnam
          hhmms0 = hhmmss
c
          timno0 = timnow
          topen  = timnow
          tclose = timnow
c
          datopn = datnam
          datclo = datnam
          timopn = hhmmss
          timclo = hhmmss
c
          zmas0  = zmassa
          zmas1  = zmassa
c          
          nwz0   = 1
          nijm0  = 1     
c
          xbstw0 = 0.0    
          xbsti0 = 0.0   
c
          frdwz0 = 0.0
          frdij0 = 0.0
c
          frswz0 = 0.0
          frsij0 = 0.0
c
c Bellenscherm-Deltares    -Waddenzee-Mean: BEL D W M
c Bellenscherm-Stevinsluis -Waddenzee-Mean: BEL S W M
c
c Bellenscherm-Deltares   -IJsselmeer-Mean: BEL D I M
c Bellenscherm-Stevinsluis-IJsselmeer-Mean: BEL S I M
c
          beldwm = 0.0
          beldim = 0.0
          watwzm = 0.0
c
          belswm = 0.0
          belsim = 0.0
c
          frwwz0 = 0.0 
c
          ifirst = 1
      endif      
c----------------------------------------------------------------------
c Voor inspectie met debugger, kopieer namen en logic-control variabelen
c naar 1D-arrays:
c----------------------------------------------------------------------
      npc = 4
      do is        = 1,38
         local(is) = signam(npc,is)
         isplc(is) = nplcs (npc,is) 
      enddo
c----------------------------------------------------------------------
c Deur open signaal, combineer eb- en vloeddeuren per zoet/zout zijde,
c controleer met 1 van de 2 deuren per set vloed- en ebdeuren.
c Het is mogelijk dat zowel eb- als vloeddeuren gesloten zijn, trunceer
c daarom NWZ of NIJM tot hooguit NWZ/NIJM=1 i.v.m. besliscriteria voor 
c openen/sluiten kolk.
c----------------------------------------------------------------------
      nwz   = min(1,isplc( 1)+isplc( 5))
      nijm  = min(1,isplc( 9)+isplc(13))
c----------------------------------------------------------------------
c rinketschuiven zee- en meer-zijde open signaal:
c----------------------------------------------------------------------
      nrwz  = isplc(17)*isplc(19)+isplc(21)*isplc(23)     
      nrijm = isplc(25)*isplc(27)+isplc(29)*isplc(31)            
c----------------------------------------------------------------------
c partiele opening rinketschuiven = lekkende ebdeuren:
c----------------------------------------------------------------------
c Zee-zijde:
      rkd3   = signal(9,5) 
      rkd4   = signal(2,8)
c Schalen met maximale opening en klippen: 
      rinwz  = (rkd3+rkd4)/riwzmx  
      rinwz  = max(0.0,min(1.0,rinwz))
c Meer-zijde:
      rkd11  = signal(9,6)
      rkd12  = signal(6,5)
c Schalen naar maximale opening en klippen: 
      rinijm = (rkd11+rkd12)/riijmx
      rinijm = max(0.0,min(1.0,rinijm))
c----------------------------------------------------------------------
c Originele Stevinsluis bellenschermen aan zee-zijde:
c
c XBSTWZ : Nummer-Bellenscherm-STevin-WaddenZee
c
c XBSTWZ = 0  geen lucht
c XBSTWZ = 1  half vermogen
c XBSTWZ = 2  vol vermogen
c----------------------------------------------------------------------
      xbstwz     = 0.0
      if (   isplc(35).eq.1 .and. isplc(34).eq.1) then
         xbstwz  = 1.0
         cval(7) = status(15)
      elseif(isplc(35).eq.1 .and. isplc(34).eq.0) then
         xbstwz = 2.0
         cval(7) = status(16)         
      else
      endif   
c----------------------------------------------------------------------
c Originele Stevinsluis bellenschermen aan meer-zijde:
c
c XBSTIJ : Nummer-Bellenscherm-STevin-IJsselmeer
c
c XBSTIJ = 0  geen lucht
c XBSTIJ = 1  half vermogen
c XBSTIJ = 2  vol vermogen
c----------------------------------------------------------------------
      xbstij    = 0.0
      if (   isplc(38).eq.1 .and. isplc(37).eq.1) then
         xbstij = 1.0
         cval(7) = status(17)
      elseif(isplc(38).eq.1 .and. isplc(37).eq.0) then
         xbstij = 2.0
         cval(7) = status(18)         
      else
      endif   
c----------------------------------------------------------------------
c Bepaal luchtdebieten (Nliter/sec) Stevinsluis-bellenschermen op basis 
c van half/vol vermogen compressor indicatoren (XBSTWZ en XBSTIJ) per 
c zee-/meerzijde. Vol vermogen levert BELMAX Nliter/sec lucht:
c----------------------------------------------------------------------
      belswz = xbstwz*belmax/2
      belsij = xbstij*belmax/2
c Froude-luchtgetallen:
      frswz  = froair (belswz,salklk,salwz ,rhoklk,rhowz )
      frsijm = froair (belsij,salklk,salijm,rhoklk,rhoijm)
c----------------------------------------------------------------------
c Deltares_bellenschermen aan:
c Sommeer luchtdebieten (liter/sec) per zee-/meerzijde:
c----------------------------------------------------------------------
      beldwz = signal(2,5)+signal(2,6)
      beldij = signal(6,2)+signal(6,3)
c----------------------------------------------------------------------
c Bellenscherm aan dan NBWZ=1 en bereken Froude-lucht-getal. Let op,
c dit Froude-getal wordt gebaseerd op de actuele dichtheid i.t.t.
c de theoretische schatting van de zoutmassa-verandering:
c----------------------------------------------------------------------
      if(beldwz.gt.belmin) then     
         frdwz  = froair (beldwz,salklk,salwz ,rhoklk,rhowz )
      else
         beldwz = 0.0
         frdwz  = 0.0
      endif
c      
      if(beldij.gt.belmin) then      
         frdijm = froair (beldij,salklk,salijm,rhoklk,rhoijm)
      else
         beldij = 0.0
         frdijm = 0.0
      endif      
c----------------------------------------------------------------------
c Deltares_waterscherm aan:
c Sommeer waterdebieten (liter/sec) alleen aan zeezijde:
c----------------------------------------------------------------------
      watwz  = signal(2,1)+signal(2,3)+signal(9,1)+signal(9,3)
      watijm = 0.0
c
      if (watwz.gt.watmin) then     
         frwwz  = froair (watwz  ,salklk,salwz ,rhoklk,rhowz )
      else
         watwz = 0.0 
         frwwz = 0.0
      endif
c----------------------------------------------------------------------
c De status indicatoren voor plotten in tijdreeks:
c
c XSTWZ  (Status zijde Waddenzee):  0.0 gesloten deuren zoute zijde
c                                   1.0 geopende rinketschuiven zoute zijde
c                                   2.0 geopende deuren zoute zijde. 
c
c Deze logica maar met een kleine off-set (0.1) om geen overlap in plot
c van blokvormen met zoutez-ijde signalen te krijgen: 
c
c XSTIJM (Status zijde IJsselmeer): 0.1  gesloten deuren zoete zijde
c                                   1.1  geopende rinketschuiven zoete zijde
c                                   2.1  geopende deuren zoete zijde. 
c----------------------------------------------------------------------
c Kolk wel/niet open naar zee:
      if (nwz.eq.0) then
          xstwz   = 2.0
          cval(1) = status(1)
      else 
          cval(1) = status(2)
c
c Zee-rinketschuiven open/dicht:
          if (nrwz.eq.0) then
              xstwz   = 1.0
              cval(2) = status(5)
c
c Vullen uit of ledigen naar zee:
              hkolkp = hkolk+tollvl
c              
              if (hwz.gt.hkolkp) then
                 cval(3) = status(9)
              else
                 cval(3) = status(10)
              endif   
          else
              xstwz   = 0.0
              cval(2) = status(6)
          endif    
      endif
c----------------------------------------------------------------------
c Kolk wel/niet open naar meer:
c----------------------------------------------------------------------
      if (nijm.eq.0) then
          xstijm  = 2.0
          cval(4) = status(3)
      else 
          cval(4) = status(4)
c
c Meer-rinketschuiven open/dicht:
c
          if (nrijm.eq.0) then
              xstijm  = 1.0
              cval(5) = status(7)
c
c Vullen uit of ledigen naar meer:
c
              if (hkolk.gt.tollvl) then
                 cval(6) = status(12)
              else
                 cval(6) = status(11)
              endif                 
          else
              xstijm  = 0.0
              cval(5) = status(8)
          endif    
      endif
c
      offset = 0.1
      xstijm = xstijm+offset
c----------------------------------------------------------------------
c Schrijven voor plotten in blokvorm via bestand STATUS.tek:
c----------------------------------------------------------------------
      nc = 7 
      write(lunplc,fmt1)
     + datna0,hhmms0,xstwz0,xstij0,frswz0,frsij0,frdwz0,frdij0,
     + frwwz0,rinwz ,rinijm,(cval(j),j=1,nc)
c     
      write(lunplc,fmt1)
     + datnam,hhmmss,xstwz ,xstijm,frswz ,frsijm,frdwz ,frdijm,
     + frwwz ,rinwz ,rinijm,(cval(j),j=1,nc)      
c----------------------------------------------------------------------
c Analyse zoutuitwiseling zeezijde, uitvoer naar 2ZEE.tek:
c 
c Controleer op verandering NWZ van dicht (1) naar open (0).
c En onthoud vanaf het moment van het openen van de sluisdeur het 
c gemiddelde zoutgehalte (SALOPN) en dichtheid (RHOOPN) in de kolk
c voor de theoretische analyse van zouttransport:
c----------------------------------------------------------------------
      n2wz = 0
c
      if (nwz.lt.nwz0) then
         topen  = timnow
         datopn = datnam
         timopn = hhmmss
         salopn = salklk
         rhoopn = rhoklk
         zmas0  = zmassa
         belswm = 0.0
         beldwm = 0.0
         watwzm = 0.0
      endif
c    
      if (nwz.gt.nwz0) then
         tclose = timnow
         datclo = datnam
         timclo = hhmmss        
         zmas1  = zmassa
         n2wz   = 1
      endif
c
c T.b.v. gemiddelden sommeer debieten bellen/waterscherm Waddenzee 
c gedurende open-tijd:
c
      if (topen.lt.timnow .and. n2wz.eq.0) then
         dt     = timnow-timno0
         belswm = belswm+belswz*dt
         beldwm = beldwm+beldwz*dt
         watwzm = watwzm+ watwz*dt         
      endif   
c----------------------------------------------------------------------
c N2WZ=1 betekent cyclus afgerond van open/dicht kolk naar Waddenzee:
c----------------------------------------------------------------------
      if (n2wz.eq.1) then
         n2ijm  = 0
         diftim = tclose-topen
         zmas2  = zmasth
c

c Gemiddelde lucht/waterdebieten:
c
         belswm = belswm/max(1.0,diftim)
         beldwm = beldwm/max(1.0,diftim)
         watwzm = watwzm/max(1.0,diftim)         
c----------------------------------------------------------------------
c Schrijven naar 2ZEE.tek alleen voor voldoende lange opentijd en 
c minimaal verschil in zoutgehalte tussen zeezijde en kolk op het moment
c van deuren open (SALOPN):
c----------------------------------------------------------------------
c
         salcrt = salwz-salopn
c         
c++      if ((diftim.gt.479.).and.(salcrt.gt.5.)) then    
         if ((diftim.gt.  0.)                   ) then    
            nc     = 6
            nlzee  = nlzee+2
c
c Zoutmassa's in [ton]:
c
            zmas0  = zmas0/1000.
            zmas1  = zmas1/1000.
            zmas2  = zmas2/1000.
c
c Waargenomen en analytische toename ZMASAN in zoutmassa:
c
            zmasob = zmas1-zmas0
            zmasan = zmas2-zmas0
            zero   = 0.0 
c
c Reductie in %: 
c
            difobs = zmas1-zmas0
            difana = zmas2-zmas0
            reduc  = 100*difobs/max(1.0,difana)
            reduc  = max(0.0,min(reduc,999.))
c

c Gebruik XNOVAL=999.999 om punten niet te plotten m.u.v. initiele 
c zoutmassa bij openen kolk:
c
            do n       = 1,20
               zval(n) = xnoval
            enddo   
            zval(1)    = zmas0 
c
c Situatie bij openen kolk:
c
            write(lunzee,fmt4a) datopn,timopn,(zval(n),n=1,16)     
c
c Situatie bij sluiten kolk:
c
            zval( 1) = xnoval
            zval( 2) = zmas1
            zval( 3) = zmas2
            zval( 4) = reduc
            zval( 5) = frswz
            zval( 6) = frdwz
            zval( 7) = frwwz
            zval( 8) = zmasob
            zval( 9) = zmasan
            zval(10) = zero  
            zval(11) = zero  
            zval(12) = zero   
            zval(13) = zero               
            zval(14) = belswm
            zval(15) = beldwm
            zval(16) = watwzm          
c
c Plaats theoretische schatting zoutmassa in juiste kolom voor
c onderscheid in plotten. Gebruik gemiddelde lucht/waterdebieten
c en hun minima (BELMIN EN WATMIN) als criterium.
c
c Stevin-bellenscherm:
c
            if (belswm.gt.belmin) then
               zval( 9) = zero   
               zval(10) = zmasan
            endif   
c
c Deltares-bellenscherm zonder waterdebiet:
c
            if (beldwm.gt.belmin .and. watwzm.lt.watmin) then
               zval( 9) = zero  
               zval(11) = zmasan
            endif   
c
c Deltares-bellenscherm met Deltares-waterdebiet:
c
            if (beldwm.gt.belmin .and. watwzm.gt.watmin) then
               zval( 9) = zero  
               zval(12) = zmasan
            endif   
c
c Zonder Deltares-bellenscherm maar met Deltares-waterdebiet:
c
            if (beldwm.lt.belmin .and. watwzm.gt.watmin) then
               zval( 9) = zero  
               zval(13) = zmasan
            endif   
c
            write(lunzee,fmt4) datclo,timclo,(zval(n),n=1,16)          
c----------------------------------------------------------------------
c Naar Logboek voor overzicht - schutten naar Waddenzee:
c----------------------------------------------------------------------
            topen  = diftim/60.
            nkeer  = nlzee/2         
            schut  = 'Zee '
            ebdeur = '       '
c
c Getijfase afhankelijk van marge HKENT voor kentering:
c
            hdif  = hwz-hijm
            hkent = 0.3
            if (abs(hdif).lt. hkent) then
               getij = 'Kenter'
            elseif   (hdif.gt.hkent) then
               getij = 'Vloed '        
            else
               getij = 'Eb    '       
c Lekkende ebdeuren:
               if (rinijm.gt.0.05) ebdeur = 'LekEbd'
            endif
c            
            write(lunana,fmt3)
     +      datclo,timclo,getij,schut,ebdeur,topen,
     +      belswm,beldwm,watwzm,zmasob,zmasan 
c
c Endif van beoordeling nuttige opening:
c
         endif
c
c Endif voor "deur sluiten":
c
      endif
c----------------------------------------------------------------------
c----------------------------------------------------------------------
c Analyse zoutuitwiseling meerzijde, uitvoer naar 2MEER.tek:
c 
c Controleer op verandering NIJM van dicht (1) naar open (0).
c En onthoud vanaf het moment van het openen van de sluisdeur het 
c gemiddelde zoutgehalte (SALOPN) en dichtheid (RHOOPN) in de kolk
c voor de theoretische analyse van zouttransport:
c----------------------------------------------------------------------
c----------------------------------------------------------------------
      n2ijm = 0
c
      if (nijm.lt.nijm0) then
         topen  = timnow
         datopn = datnam
         timopn = hhmmss
         salopn = salklk
         rhoopn = rhoklk 
         zmas0  = zmassa
         belsim = 0.0
         beldim = 0.0
      endif
c 
      if(nijm.gt.nijm0) then
         tclose = timnow
         datclo = datnam
         timclo = hhmmss        
         zmas1  = zmassa
         n2ijm  = 1
      endif
c
c T.b.v. gemiddelden sommeer debieten bellen/waterscherm Waddenzee 
c gedurende open-tijd:
c
      if (topen.lt.timnow .and. n2ijm.eq.0) then
         dt     = timnow-timno0
         belsim = belsim+belsij*dt
         beldim = beldim+beldij*dt         
      endif   
c----------------------------------------------------------------------
c N2IJM=1 betekent cyclus afgerond van open/dicht kolk naar IJsselmeer:
c----------------------------------------------------------------------
      if (n2ijm.eq.1) then
         n2wz   = 0  
         diftim = tclose-topen
         zmas2  = zmasth
c
c Gemiddeld luchtdebiet:         
c
         belsim = belsim/max(1.0,diftim)        
         beldim = beldim/max(1.0,diftim)              
c----------------------------------------------------------------------
c Schrijven naar 2MEER.tek voor voldoende lange opentijd en groot
c verschil in zoutgehalte tussen kolk en meer:
c----------------------------------------------------------------------
c
         salcrt = salopn-salijm
c
c++      if ((diftim.gt.479.).and.(salcrt.gt.5.)) then
         if ((diftim.gt.  0.)                   ) then
            nlmeer  = nlmeer+2
c
c Zoutmassa's in [ton]:
c  
            zmas0  = zmas0/1000.
            zmas1  = zmas1/1000.
            zmas2  = zmas2/1000.     
c
c Waargenomen en theoretische toename in zoutmassa:
c
            zmasob = zmas0-zmas1
            zmasan = zmas0-zmas2
            zero   = 0.0 
c
c Reductie in %: 
c
            difobs = zmas0-zmas1
            difana = zmas0-zmas2
            reduc  = 100*difobs/max(1.0,difana)
            reduc  = max(0.0,min(reduc,999.))
c
c Gebruik XNOVAL=999.999 om punten niet te plotten m.u.v. initiele 
c zoutmassa bij openen kolk:
c
            do n       = 1,20
               zval(n) = xnoval
            enddo   
            zval(1)    = zmas0
c
c Situatie bij openen kolk:
c
            write(lunmee,fmt2a) datopn,timopn,(zval(n),n=1,12)     
c
c Situatie na sluiten kolk: 
c
            zval( 1) = xnoval
            zval( 2) = zmas1
            zval( 3) = zmas2
            zval( 4) = reduc
            zval( 5) = frsijm
            zval( 6) = frdijm
            zval( 7) = zmasob
            zval( 8) = zmasan
            zval( 9) = zero  
            zval(10) = zero  
            zval(11) = belsim
            zval(12) = beldim       
c            
            if (belsim.gt.belmin) then
               zval( 8) = zero   
               zval( 9) = zmasan
            endif   
            if (beldim.gt.belmin) then
               zval( 8) = zero  
               zval(10) = zmasan
            endif   
c
            write(lunmee,fmt2) datclo,timclo,(zval(n),n=1,12)               
c----------------------------------------------------------------------
c Naar Logboek voor overzicht - schutten naar IJsselmeer:
c----------------------------------------------------------------------
            topen  = diftim/60.
            nkeer  = nlmeer/2         
            schut  = 'Meer'
            ebdeur = '       '         
c
c Getijfase afhankelijk van marge HKENT:
c
            hdif  = hwz-hijm
            hkent = 0.1
            if (abs(hdif).lt. hkent) then
               getij = 'Kenter'
            elseif   (hdif.gt.hkent) then
               getij = 'Vloed '         
            else
               getij = 'Eb    '       
c Lekkende ebdeuren:
               if (rinwz .gt.0.05) ebdeur = 'LekEbd'
            endif         
c               
            write(lunana,fmt3)
     +      datclo,timclo,getij,schut,ebdeur,topen,
     +      belsim,beldij,watijm,zmasob,zmasan
c
c Endif van beoordeling nuttige opening:
c
         endif
c
c Endif voor "deur sluiten":
c
      endif
c----------------------------------------------------------------------
c Onthoud laaste datum, tijd, status-indicatoren en zoutmassa:
c----------------------------------------------------------------------
      xstwz0 = xstwz
      xstij0 = xstijm
c

      timno0 = timnow
      datna0 = datnam
      hhmms0 = hhmmss
c
      nwz0   = nwz
      nijm0  = nijm
c
      xbstw0 = xbstwz
      xbsti0 = xbstij
c      
      frdwz0 = frdwz
      frdij0 = frdijm
c
      frswz0 = frswz
      frsij0 = frsijm
c
      frwwz0 = frwwz
c
      return
      end
