      subroutine lockex(salt0 ,salt1 ,rho0  ,rho1  ,etta  ,
     +                  cwav  ,hbed  ,hsprng,volflx,salflx) 
c************************************************************************
c
c         D e l t a r e s  -   Unit: Deltares Software Centre
c
c
c             Module: subroutine LOCKEX
c           Function: Specifieke volume- en zoutfluxen volgens 
c                     "lock exchange" theorie, Shin, Dalziel & 
c                     Linden (JFM, 2004), met ev. reductie (ETTA)
c                     door bellenscherm.
c
c        Method used: Aanroep in subroutine PLCLOG.
c               Date: 28-04-2010
c         Programmer: R.E. Uittenbogaard
c************************************************************************
c
      include 'hydarr.inc'
      include 'physco.inc'
c
      rho    = 0.5*(rho0+rho1)
      delrho = abs(rho1-rho0)
      dh     = hsprng/hbed
      cwav   = sqrt(ag*delrho*hbed/rho)
c
c Zonder energieverlies:
c
      fh     = 0.5*sqrt(dh*(2-dh))
c
c Maximaal energieverlies:
c
c++   fh     = 0.527*sqrt(dh*(2-dh))
c     
      ulock  = fh*cwav
c
c Specifiek volume-flux QLOCK en zout-flux SALFLX, zonder
c energieverlies:
c
      qlock  = 0.5*ulock*hsprng 
c
c Specifiek volume-flux QLOCK en zout-flux SALFLX, maximaal
c energieverlies:
c
c++   qlock  = 0.347*ulock*hsprng 
c      
c Specifiek volume-flux ev. gereduceerd door bellenscherm:
c
      volflx = etta*qlock 
c
c Teken/richting:
c
      if (salt1.gt.salt0) volflx=-volflx
c
c Specifiek zoutflux:
c
      salflx = volflx*abs(salt0-salt1)
      return
      end
